/*
 * Decompiled with CFR 0.152.
 */
package tp4;

import tp4.MatriceCarreeException;

public class MatriceCarree {
    double[][] representation;
    int degre;

    public MatriceCarree() {
        this.representation = null;
        this.degre = 0;
    }

    public MatriceCarree(int d) {
        this.representation = new double[d][d];
        this.degre = d;
        this.zero();
    }

    public MatriceCarree(double[][] r) {
        if (r == null) {
            this.degre = 0;
            this.representation = null;
        } else {
            this.degre = r[0].length;
            this.representation = (double[][])r.clone();
        }
    }

    public void zero() {
        for (int i = 0; i < this.degre; ++i) {
            for (int j = 0; j < this.degre; ++j) {
                this.representation[i][j] = 0.0;
            }
        }
    }

    public void unite() {
        this.zero();
        for (int i = 0; i < this.degre; ++i) {
            this.representation[i][i] = 1.0;
        }
    }

    public MatriceCarree addition(MatriceCarree mc) throws MatriceCarreeException {
        if (this.degre != mc.degre) {
            throw new MatriceCarreeException("addition : matrice de degr\u00e9s diff\u00e9rents");
        }
        MatriceCarree res = new MatriceCarree(this.degre);
        for (int i = 0; i < this.degre; ++i) {
            for (int j = 0; j < this.degre; ++j) {
                res.representation[i][j] = this.representation[i][j] + mc.representation[i][j];
            }
        }
        return res;
    }

    public MatriceCarree soustraction(MatriceCarree mc) throws MatriceCarreeException {
        if (this.degre != mc.degre) {
            throw new MatriceCarreeException("soustraction : matrice de degr\u00e9s diff\u00e9rents");
        }
        MatriceCarree res = new MatriceCarree(this.degre);
        for (int i = 0; i < this.degre; ++i) {
            for (int j = 0; j < this.degre; ++j) {
                res.representation[i][j] = this.representation[i][j] - mc.representation[i][j];
            }
        }
        return res;
    }

    public MatriceCarree multiplication(MatriceCarree mc) throws MatriceCarreeException {
        if (this.degre != mc.degre) {
            throw new MatriceCarreeException("multiplication : matrice de degr\u00e9s diff\u00e9rents");
        }
        MatriceCarree res = new MatriceCarree(this.degre);
        for (int i = 0; i < this.degre; ++i) {
            for (int j = 0; j < this.degre; ++j) {
                double x = 0.0;
                for (int k = 0; k < this.degre; ++k) {
                    x += this.representation[i][k] * mc.representation[k][j];
                }
                res.representation[i][j] = x;
            }
        }
        return res;
    }

    public void transpose() {
        for (int i = 0; i < this.degre; ++i) {
            for (int j = 0; j < i; ++j) {
                double x = this.representation[i][j];
                this.representation[i][j] = this.representation[j][i];
                this.representation[j][i] = x;
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof MatriceCarree)) {
            return false;
        }
        MatriceCarree x = (MatriceCarree)o;
        for (int i = 0; i < this.degre; ++i) {
            for (int j = 0; j < this.degre; ++j) {
                if (this.representation[i][j] == this.representation[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public Object clone() {
        return new MatriceCarree(this.representation);
    }

    public boolean estSymetrique() {
        for (int i = 0; i < this.degre; ++i) {
            for (int j = 0; j < i; ++j) {
                if (this.representation[i][j] == this.representation[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    public double elementAt(int i, int j) throws MatriceCarreeException {
        if (i < 0 || i >= this.degre || j < 0 || j >= this.degre) {
            throw new MatriceCarreeException("indice en dehors des bornes");
        }
        return this.representation[i][j];
    }

    public void setElementAt(double x, int i, int j) throws MatriceCarreeException {
        if (i < 0 || i >= this.degre || j < 0 || j >= this.degre) {
            throw new MatriceCarreeException("indice en dehors des bornes");
        }
        this.representation[i][j] = x;
    }

    public String toString() {
        String res = "";
        for (int i = 0; i < this.degre; ++i) {
            for (int j = 0; j < this.degre; ++j) {
                res = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(res))).append(" ").append(Double.toString(this.representation[i][j]))));
            }
            res = String.valueOf(String.valueOf(res)).concat("\n");
        }
        return res;
    }
}

